'''
    Copyright 2014 Frederic Rible (frible@teaser.fr)

    
    -----
     
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

'''
import ctypes
import mmap
import os
import struct
import pickle
import unittest

class sharedvar:
    def __init__(self, filename = "/tmp/linuxcnc.sharedvar"):
        do_init = False
        try:
            self.fd = fd = os.open(filename, os.O_RDWR)
        except os.error:
            self.fd = fd = os.open(filename, os.O_CREAT | os.O_TRUNC | os.O_RDWR)
            os.write(fd, '\x00' * mmap.PAGESIZE) == mmap.PAGESIZE
            do_init = True
        buf = mmap.mmap(fd, mmap.PAGESIZE, mmap.MAP_SHARED, mmap.PROT_WRITE)
        s_type = ctypes.c_char * mmap.PAGESIZE
        self.buf = s_type.from_buffer(buf)
        if do_init:
            data = {}
            self.buf.raw = pickle.dumps(data)
            
    def __del__(self):
        os.close(self.fd)
        
    def __getitem__(self, index):
        data = pickle.loads(self.buf.raw)
        try:
            return data[index]
        except:
            return None
    
    def __setitem__(self, index, value):
        data = pickle.loads(self.buf.raw)
        data[index] = value
        self.buf.raw = pickle.dumps(data)
          
class Test(unittest.TestCase):
 
    def setUp(self):
        pass
 
    def test_1(self):
        s = sharedvar()
        s[1] = 4.0
        s[2] = 3.0
        s[3] = "toto"
        self.assertEqual( s[1], 4.0 )
        self.assertEqual( s[2], 3.0 )
        self.assertEqual( s[3], "toto" )
        del s
        
    def test_2(self):
        s = sharedvar()
        self.assertEqual( s[1], 4.0 )
        self.assertEqual( s[2], 3.0 )
        self.assertEqual( s[3], "toto" )
        self.assertEqual( s[4], None )
        del s
                       
if __name__ == '__main__':
    unittest.main()