#!/usr/bin/env python

import gtk
import glib
import linuxcnc
import time
import hal_glib
import hal

from gladevcp.persistence import IniFile,widget_defaults,set_debug,select_widgets

def get_handlers(halcomp,builder,useropts):
	return [Probe(halcomp,builder,useropts)]

# a class for holding the glade widgets rather then searching for them each time
# code coming from gscreen
class Widgets:
    def __init__(self, xml):
        self._xml = xml
    def __getattr__(self, attr):
        r = self._xml.get_object(attr)
        if r is None: raise AttributeError, "No widget %r" % attr
        return r
    def __getitem__(self, attr):
        r = self._xml.get_object(attr)
        if r is None: raise IndexError, "No widget %r" % attr
        return r
       
class Probe :
	def __init__(self, halcomp,builder,useropts):
		self.halcomp = halcomp
		self.builder = builder
		self.useropts = useropts
		self.ini_filename = __name__ + '.ini'
		self.defaults = {
			IniFile.vars: dict(),
			IniFile.widgets : widget_defaults(select_widgets(self.builder.get_objects(), hal_only=False,output_only = True))
		}
		self.ini = IniFile(self.ini_filename,self.defaults,self.builder)
		self.ini.restore_state(self)
		
		self.emcstat = linuxcnc.stat()
		self.cmd = linuxcnc.command()
		
		self.widgets = Widgets(self.builder)
		
		self.widgets["reftool"].set_active(False)
		self.widgets["offset-x"].set_value(0.0)
		self.widgets["offset-y"].set_value(0.0)
		self.widgets["offset-z"].set_value(0.0)
	
		self.restore_manual = False

		self.pin_touch_off = hal_glib.GPin(self.halcomp.newpin("touch-off", hal.HAL_BIT, hal.HAL_IN))
		self.pin_enable_x = hal_glib.GPin(self.halcomp.newpin("enable-x", hal.HAL_BIT, hal.HAL_IN))
		self.pin_enable_y = hal_glib.GPin(self.halcomp.newpin("enable-y", hal.HAL_BIT, hal.HAL_IN))
		self.pin_enable_z = hal_glib.GPin(self.halcomp.newpin("enable-z", hal.HAL_BIT, hal.HAL_IN))
		self.pin_touch_off.connect("value_changed", self._on_touch_off_changed)
		
		self.pin_gremlin_refresh = hal_glib.GPin(self.halcomp.newpin("gremlin-refresh", hal.HAL_BIT, hal.HAL_OUT))
		self.trig_gremlin_refresh = False
		
		glib.timeout_add(100, self.periodic)
			
	def on_destroy(self,obj,data=None):
		self.ini.save_state(self)
		
	def periodic(self):
		self.emcstat.poll()
		self.widgets["probing-led"].set_active(self.emcstat.probing)
		self.widgets["time-text"].set_label(time.strftime("%H:%M:%S"))
		if self.emcstat.interp_state == linuxcnc.INTERP_IDLE and self.restore_manual:
			print "restore manual"
			self.cmd.mode(linuxcnc.MODE_MANUAL)
			self.restore_manual = False
			if (self.trig_gremlin_refresh):
				self.pin_gremlin_refresh.set(not self.pin_gremlin_refresh.get())
				self.trig_gremlin_refresh = False
		return True
        
	def on_btn_probe_X_pressed(self, widget, axis=None):
		self.probe("x")

	def on_btn_probe_Y_pressed(self, widget, axis=None):
		self.probe("y")
		
	def on_btn_probe_Z_pressed(self, widget, axis=None):
		self.probe("z")

	def _on_touch_off_changed(self, pin):
		if (not pin.get()):
			return
		if (self.pin_enable_x.value):
			self.probe("x")
		if (self.pin_enable_y.value):
			self.probe("y")
		if (self.pin_enable_z.value):
			self.probe("z")

	def mdi_command(self, cmd):
		self.cmd.mode(linuxcnc.MODE_MDI)
		self.cmd.wait_complete()
		self.cmd.mdi(cmd)
		self.restore_manual = True
		
	def probe(self, axis):
		print "on_btn_probe_clicked %s" % axis
		cmd = "o<touch-off-%s>call [%f] [%f]" % (axis, self.widgets["offset-%s" % axis].get_value(), self.widgets["plate-thickness"].get_value())
		self.mdi_command(cmd)
		self.trig_gremlin_refresh = True




